/**
  ******************************************************************************
  * @file    fibonacci.h 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   Helper functions
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 


#ifndef _fibonacci_h
#define _fibonacci_h

#define MAXFIBONACCITESTS 35

enum
{
    FIBTEST_INTERNALFLASH_INTERNALSRAM = 0,
    FIBTEST_INTERNALFLASH_EXTERNALSRAM,
    FIBTEST_EXTERNALFLASH_INTERNALSRAM,
    FIBTEST_EXTERNALFLASH_EXTERNALSRAM,
    FIBTEST_EXTERNALFLASH_MAPPEDTOIBUS_INTERNALSRAM,
    FIBTEST_EXTERNALFLASH_MAPPEDTOIBUS_INTERNALSRAM_ZEROBASED,
    FIBTEST_EXTERNALFLASH_MAPPEDTOIBUS_EXTERNALSRAM_ZEROBASED,
    FIBTEST_MAX
};

enum
{
    FIBTEST_RESULTITEM_FIBRETURN = 0,
    FIBTEST_RESULTITEM_TURNAROUND_IN_MS,
    FIBTEST_RESULTITEM_DWTCYCLECOUNTER,
    FIBTEST_RESULTITEM_ALL
};

enum
{
    FIBTEST_USE_FULLY_RECURSIVE_IMPLEMENTATION = 0,
    FIBTEST_USE_FULLY_TAIL_RECURSIVE_IMPLEMENTATION,
    FIBTEST_USE_PARTIALLY_TAIL_RECURSIVE_IMPLEMENTATION,
    FIBTEST_USE_MAX
};

typedef unsigned long (*FibonacciFn)(unsigned long p_Arg,unsigned long *p_TimeNeeded,unsigned long *p_CyclesNeeded,unsigned long p_Implementation);

extern unsigned long Fibonacci(unsigned long p_Arg,unsigned long *p_TimeNeeded,unsigned long *p_CyclesNeeded,unsigned long p_Implementation);


#endif